/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.resources.IModelObjectConstants;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectDescriptionReader
extends DefaultHandler
implements IModelObjectConstants {
    protected static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final int S_BUILD_COMMAND = 4;
    protected static final int S_BUILD_COMMAND_ARGUMENTS = 11;
    protected static final int S_BUILD_COMMAND_NAME = 10;
    protected static final int S_BUILD_SPEC = 3;
    protected static final int S_DICTIONARY = 12;
    protected static final int S_DICTIONARY_KEY = 13;
    protected static final int S_DICTIONARY_VALUE = 14;
    protected static final int S_INITIAL = 0;
    protected static final int S_LINK = 17;
    protected static final int S_LINK_LOCATION = 20;
    protected static final int S_LINK_NAME = 18;
    protected static final int S_LINK_TYPE = 19;
    protected static final int S_LINKED_RESOURCES = 16;
    protected static final int S_NATURE_NAME = 15;
    protected static final int S_NATURES = 5;
    protected static final int S_PROJECT_COMMENT = 8;
    protected static final int S_PROJECT_DESC = 2;
    protected static final int S_PROJECT_NAME = 7;
    protected static final int S_PROJECTS = 6;
    protected static final int S_REFERENCED_PROJECT_NAME = 9;
    protected static final int S_WORKSPACE_DESC = 1;
    protected final StringBuffer charBuffer = new StringBuffer();
    protected Stack objectStack;
    protected MultiStatus problems;
    ProjectDescription projectDescription = null;
    protected int state = 0;

    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.charBuffer.append(chars, offset, length);
    }

    private void endBuildCommandElement(String elementName) {
        if (elementName.equals("buildCommand")) {
            BuildCommand command = (BuildCommand)this.objectStack.pop();
            ArrayList commandList = (ArrayList)this.objectStack.peek();
            commandList.add(command);
            this.state = 3;
        }
    }

    private void endBuildSpecElement(String elementName) {
        if (elementName.equals("buildSpec")) {
            ArrayList commands = (ArrayList)this.objectStack.pop();
            this.state = 2;
            if (commands.isEmpty()) {
                return;
            }
            ICommand[] commandArray = commands.toArray(new ICommand[commands.size()]);
            this.projectDescription.setBuildSpec(commandArray);
        }
    }

    private void endDictionary(String elementName) {
        if (elementName.equals("dictionary")) {
            String value = (String)this.objectStack.pop();
            String key = (String)this.objectStack.pop();
            ((HashMap)this.objectStack.peek()).put(key, value);
            this.state = 11;
        }
    }

    private void endDictionaryKey(String elementName) {
        if (elementName.equals("key")) {
            String value = (String)this.objectStack.pop();
            String oldKey = (String)this.objectStack.pop();
            String newKey = this.charBuffer.toString();
            if (oldKey != null && oldKey.length() != 0) {
                this.parseProblem(Policy.bind("projectDescriptionReader.whichKey", oldKey, newKey));
                this.objectStack.push(oldKey);
            } else {
                this.objectStack.push(newKey);
            }
            this.objectStack.push(value);
            this.state = 12;
        }
    }

    private void endDictionaryValue(String elementName) {
        if (elementName.equals("value")) {
            String newValue = this.charBuffer.toString();
            String oldValue = (String)this.objectStack.pop();
            if (oldValue != null && oldValue.length() != 0) {
                this.parseProblem(Policy.bind("projectDescriptionReader.whichValue", oldValue, newValue));
                this.objectStack.push(oldValue);
            } else {
                this.objectStack.push(newValue);
            }
            this.state = 12;
        }
    }

    public void endElement(String uri, String elementName, String qname) throws SAXException {
        switch (this.state) {
            case 2: {
                break;
            }
            case 7: {
                if (!elementName.equals("name")) break;
                this.projectDescription.setName(this.charBuffer.toString().trim());
                this.state = 2;
                break;
            }
            case 6: {
                if (!elementName.equals("projects")) break;
                this.endProjectsElement(elementName);
                this.state = 2;
                break;
            }
            case 12: {
                this.endDictionary(elementName);
                break;
            }
            case 11: {
                if (!elementName.equals("arguments")) break;
                HashMap dictionaryArgs = (HashMap)this.objectStack.pop();
                this.state = 4;
                if (dictionaryArgs.isEmpty()) break;
                ((BuildCommand)this.objectStack.peek()).setArguments(dictionaryArgs);
                break;
            }
            case 4: {
                this.endBuildCommandElement(elementName);
                break;
            }
            case 3: {
                this.endBuildSpecElement(elementName);
                break;
            }
            case 5: {
                this.endNaturesElement(elementName);
                break;
            }
            case 17: {
                this.endLinkElement(elementName);
                break;
            }
            case 16: {
                this.endLinkedResourcesElement(elementName);
                return;
            }
            case 8: {
                if (!elementName.equals("comment")) break;
                this.projectDescription.setComment(this.charBuffer.toString());
                this.state = 2;
                break;
            }
            case 9: {
                if (!elementName.equals("project")) break;
                ((ArrayList)this.objectStack.peek()).add(this.charBuffer.toString().trim());
                this.state = 6;
                break;
            }
            case 10: {
                if (!elementName.equals("name")) break;
                ((BuildCommand)this.objectStack.peek()).setName(this.charBuffer.toString().trim());
                this.state = 4;
                break;
            }
            case 13: {
                this.endDictionaryKey(elementName);
                break;
            }
            case 14: {
                this.endDictionaryValue(elementName);
                break;
            }
            case 15: {
                if (!elementName.equals("nature")) break;
                ((ArrayList)this.objectStack.peek()).add(this.charBuffer.toString().trim());
                this.state = 5;
                break;
            }
            case 18: {
                this.endLinkName(elementName);
                break;
            }
            case 19: {
                this.endLinkType(elementName);
                break;
            }
            case 20: {
                this.endLinkLocation(elementName);
            }
        }
        this.charBuffer.setLength(0);
    }

    private void endLinkedResourcesElement(String elementName) {
        if (elementName.equals("linkedResources")) {
            HashMap linkedResources = (HashMap)this.objectStack.pop();
            this.state = 2;
            if (linkedResources.isEmpty()) {
                return;
            }
            this.projectDescription.setLinkDescriptions(linkedResources);
        }
    }

    private void endLinkElement(String elementName) {
        if (elementName.equals("link")) {
            this.state = 16;
            LinkDescription link = (LinkDescription)this.objectStack.pop();
            String name = link.getName();
            int type = link.getType();
            IPath location = link.getLocation();
            if (name == null || name.length() == 0) {
                this.parseProblem(Policy.bind("projectDescriptionReader.emptyLinkName", Integer.toString(type), location.toString()));
                return;
            }
            if (type == -1) {
                this.parseProblem(Policy.bind("projectDescriptionReader.badLinkType", name, location.toString()));
                return;
            }
            if (location.isEmpty()) {
                this.parseProblem(Policy.bind("projectDescriptionReader.badLinkLocation", name, Integer.toString(type)));
                return;
            }
            ((HashMap)this.objectStack.peek()).put(link.getName(), link);
        }
    }

    private void endLinkLocation(String elementName) {
        if (elementName.equals("location")) {
            String newLocation = this.charBuffer.toString().trim();
            IPath oldLocation = ((LinkDescription)this.objectStack.peek()).getLocation();
            if (!oldLocation.isEmpty()) {
                this.parseProblem(Policy.bind("projectDescriptionReader.badLocation", oldLocation.toString(), newLocation));
            } else {
                ((LinkDescription)this.objectStack.peek()).setLocation(new Path(newLocation));
            }
            this.state = 17;
        }
    }

    private void endLinkName(String elementName) {
        if (elementName.equals("name")) {
            String newName = this.charBuffer.toString().trim();
            String oldName = ((LinkDescription)this.objectStack.peek()).getName();
            if (oldName.length() != 0) {
                this.parseProblem(Policy.bind("projectDescriptionReader.badLinkName", oldName, newName));
            } else {
                ((LinkDescription)this.objectStack.peek()).setName(newName);
            }
            this.state = 17;
        }
    }

    private void endLinkType(String elementName) {
        if (elementName.equals("type")) {
            int newType = 1;
            try {
                newType = Integer.parseInt(this.charBuffer.toString().trim());
            }
            catch (NumberFormatException e) {
                this.log(e);
            }
            int oldType = ((LinkDescription)this.objectStack.peek()).getType();
            if (oldType != -1) {
                this.parseProblem(Policy.bind("projectDescriptionReader.badLinkType", Integer.toString(oldType), Integer.toString(newType)));
            } else {
                ((LinkDescription)this.objectStack.peek()).setType(newType);
            }
            this.state = 17;
        }
    }

    private void endNaturesElement(String elementName) {
        if (elementName.equals("natures")) {
            ArrayList natures = (ArrayList)this.objectStack.pop();
            this.state = 2;
            if (natures.size() == 0) {
                return;
            }
            String[] natureNames = natures.toArray(new String[natures.size()]);
            this.projectDescription.setNatureIds(natureNames);
        }
    }

    private void endProjectsElement(String elementName) {
        ArrayList referencedProjects = (ArrayList)this.objectStack.pop();
        if (referencedProjects.size() == 0) {
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = new IProject[referencedProjects.size()];
        int i = 0;
        while (i < projects.length) {
            projects[i] = root.getProject((String)referencedProjects.get(i));
            ++i;
        }
        this.projectDescription.setReferencedProjects(projects);
    }

    public void error(SAXParseException error) throws SAXException {
        this.log(error);
    }

    public void fatalError(SAXParseException error) throws SAXException {
        String message = error.getMessage();
        this.problems.add(new Status(4, "org.eclipse.core.resources", 567, message == null ? "" : message, error));
        throw error;
    }

    protected void log(Exception ex) {
        String message = ex.getMessage();
        this.problems.add(new Status(2, "org.eclipse.core.resources", 567, message == null ? "" : message, ex));
    }

    private void parseProblem(String errorMessage) {
        this.problems.add(new Status(2, "org.eclipse.core.resources", 567, errorMessage, null));
    }

    private void parseProjectDescription(String elementName) {
        if (elementName.equals("name")) {
            this.state = 7;
            return;
        }
        if (elementName.equals("comment")) {
            this.state = 8;
            return;
        }
        if (elementName.equals("projects")) {
            this.state = 6;
            this.objectStack.push(new ArrayList());
            return;
        }
        if (elementName.equals("buildSpec")) {
            this.state = 3;
            this.objectStack.push(new ArrayList());
            return;
        }
        if (elementName.equals("natures")) {
            this.state = 5;
            this.objectStack.push(new ArrayList());
            return;
        }
        if (elementName.equals("linkedResources")) {
            this.objectStack.push(new HashMap());
            this.state = 16;
            return;
        }
    }

    public ProjectDescription read(InputSource input) {
        this.problems = new MultiStatus("org.eclipse.core.resources", 567, Policy.bind("projectDescriptionReader.failureReadingProjectDesc"), null);
        this.objectStack = new Stack();
        this.state = 0;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://xml.org/sax/features/string-interning", true);
            }
            catch (SAXException sAXException) {}
            SAXParser parser = factory.newSAXParser();
            parser.parse(input, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            this.log(e);
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (SAXException e) {
            this.log(e);
        }
        switch (this.problems.getSeverity()) {
            case 4: {
                ResourcesPlugin.getPlugin().getLog().log(this.problems);
                return null;
            }
            case 1: 
            case 2: {
                ResourcesPlugin.getPlugin().getLog().log(this.problems);
            }
        }
        return this.projectDescription;
    }

    public ProjectDescription read(IPath location) throws IOException {
        ProjectDescription projectDescription;
        block2: {
            BufferedInputStream file = null;
            try {
                file = new BufferedInputStream(new FileInputStream(location.toFile()));
                projectDescription = this.read(new InputSource(file));
                Object var3_4 = null;
                if (file == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_5 = null;
                    if (file == null) break block3;
                    file.close();
                }
                throw throwable;
            }
            file.close();
        }
        return projectDescription;
    }

    public ProjectDescription read(IPath location, IPath tempLocation) throws IOException {
        ProjectDescription projectDescription;
        SafeFileInputStream file = new SafeFileInputStream(location.toOSString(), tempLocation.toOSString());
        try {
            projectDescription = this.read(new InputSource(file));
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            file.close();
            throw throwable;
        }
        file.close();
        return projectDescription;
    }

    public void startElement(String uri, String elementName, String qname, Attributes attributes) throws SAXException {
        this.charBuffer.setLength(0);
        switch (this.state) {
            case 0: {
                if (elementName.equals("projectDescription")) {
                    this.state = 2;
                    this.projectDescription = new ProjectDescription();
                    break;
                }
                throw new SAXException(Policy.bind("projectDescriptionReader.notProjectDescription", elementName));
            }
            case 2: {
                this.parseProjectDescription(elementName);
                break;
            }
            case 6: {
                if (!elementName.equals("project")) break;
                this.state = 9;
                break;
            }
            case 3: {
                if (!elementName.equals("buildCommand")) break;
                this.state = 4;
                this.objectStack.push(new BuildCommand());
                break;
            }
            case 4: {
                if (elementName.equals("name")) {
                    this.state = 10;
                    break;
                }
                if (!elementName.equals("arguments")) break;
                this.state = 11;
                this.objectStack.push(new HashMap());
                break;
            }
            case 11: {
                if (!elementName.equals("dictionary")) break;
                this.state = 12;
                this.objectStack.push(new String());
                this.objectStack.push(new String());
                break;
            }
            case 12: {
                if (elementName.equals("key")) {
                    this.state = 13;
                    break;
                }
                if (!elementName.equals("value")) break;
                this.state = 14;
                break;
            }
            case 5: {
                if (!elementName.equals("nature")) break;
                this.state = 15;
                break;
            }
            case 16: {
                if (!elementName.equals("link")) break;
                this.state = 17;
                this.objectStack.push(new LinkDescription());
                break;
            }
            case 17: {
                if (elementName.equals("name")) {
                    this.state = 18;
                    break;
                }
                if (elementName.equals("type")) {
                    this.state = 19;
                    break;
                }
                if (!elementName.equals("location")) break;
                this.state = 20;
            }
        }
    }

    public void warning(SAXParseException error) throws SAXException {
        this.log(error);
    }
}

