/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.NodeSearcher;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

class CompilationUnitResolver
extends Compiler {
    public CompilationUnitResolver(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, false);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    private static Parser createDomParser(ProblemReporter problemReporter) {
        return new Parser(problemReporter, false){

            public void checkComment() {
                if (this.currentElement != null && this.scanner.commentPtr >= 0) {
                    this.flushCommentsDefinedPriorTo(this.endStatementPosition);
                }
                boolean deprecated = false;
                boolean checkDeprecated = false;
                int lastCommentIndex = -1;
                lastCommentIndex = this.scanner.commentPtr;
                while (lastCommentIndex >= 0) {
                    int commentSourceStart = this.scanner.commentStarts[lastCommentIndex];
                    if ((this.modifiersSourceStart == -1 || this.modifiersSourceStart >= commentSourceStart) && this.scanner.commentStops[lastCommentIndex] >= 0) {
                        checkDeprecated = true;
                        int commentSourceEnd = this.scanner.commentStops[lastCommentIndex] - 1;
                        deprecated = this.javadocParser.checkDeprecation(commentSourceStart, commentSourceEnd);
                        this.javadoc = this.javadocParser.javadoc;
                        break;
                    }
                    --lastCommentIndex;
                }
                if (deprecated) {
                    this.checkAndSetModifiers(0x100000);
                }
                if (lastCommentIndex >= 0 && checkDeprecated) {
                    this.modifiersSourceStart = this.scanner.commentStarts[lastCommentIndex];
                }
            }
        };
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return false;
            }
        };
    }

    protected static INameEnvironment getNameEnvironment(ICompilationUnit sourceUnit) throws JavaModelException {
        return (SearchableEnvironment)((JavaProject)sourceUnit.getJavaProject()).getSearchableNameEnvironment();
    }

    protected static INameEnvironment getNameEnvironment(IJavaProject javaProject) throws JavaModelException {
        return (SearchableEnvironment)((JavaProject)javaProject).getSearchableNameEnvironment();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    public void initializeParser() {
        this.parser = CompilationUnitResolver.createDomParser(this.problemReporter);
    }

    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        super.handleInternalException(internalException, unit, result);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        super.handleInternalException(abortException, unit);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    public static CompilationUnitDeclaration resolve(ICompilationUnit unitElement, boolean cleanUp, char[] source) throws JavaModelException {
        char[] fileName = unitElement.getElementName().toCharArray();
        IJavaProject project = unitElement.getJavaProject();
        CompilationUnitResolver compilationUnitVisitor = new CompilationUnitResolver(CompilationUnitResolver.getNameEnvironment(unitElement), CompilationUnitResolver.getHandlingPolicy(), project.getOptions(true), CompilationUnitResolver.getRequestor(), new DefaultProblemFactory());
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = project.getOption("org.eclipse.jdt.core.encoding", true);
            IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(source, expectedPackageName, new String(fileName), encoding), true, true, true);
            Object var10_11 = null;
            if (cleanUp && unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block4: {
                Object var10_12 = null;
                if (!cleanUp || unit == null) break block4;
                unit.cleanUp();
            }
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration parse(char[] source, Map settings) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        Parser parser = CompilationUnitResolver.createDomParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory()));
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(sourceUnit, new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit));
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            compilationUnitDeclaration.ignoreFurtherInvestigation = true;
            return compilationUnitDeclaration;
        }
        parser.scanner.setSource(source);
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            int i = types.length;
            while (--i >= 0) {
                types[i].parseMethod(parser, compilationUnitDeclaration);
            }
        }
        return compilationUnitDeclaration;
    }

    public static CompilationUnitDeclaration parse(char[] source, NodeSearcher nodeSearcher, Map settings) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        Parser parser = CompilationUnitResolver.createDomParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory()));
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(sourceUnit, new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit));
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            compilationUnitDeclaration.ignoreFurtherInvestigation = true;
            return null;
        }
        int searchPosition = nodeSearcher.position;
        if (searchPosition < 0 || searchPosition > source.length) {
            return compilationUnitDeclaration;
        }
        compilationUnitDeclaration.traverse((ASTVisitor)nodeSearcher, compilationUnitDeclaration.scope);
        ASTNode node = nodeSearcher.found;
        if (node == null) {
            return compilationUnitDeclaration;
        }
        TypeDeclaration enclosingTypeDeclaration = nodeSearcher.enclosingType;
        if (node instanceof AbstractMethodDeclaration) {
            ((AbstractMethodDeclaration)node).parseStatements(parser, compilationUnitDeclaration);
        } else if (enclosingTypeDeclaration != null) {
            if (node instanceof Initializer) {
                ((Initializer)node).parseStatements(parser, enclosingTypeDeclaration, compilationUnitDeclaration);
            } else {
                ((TypeDeclaration)node).parseMethod(parser, compilationUnitDeclaration);
            }
        }
        return compilationUnitDeclaration;
    }

    public static CompilationUnitDeclaration resolve(char[] source, String unitName, IJavaProject javaProject, boolean cleanUp) throws JavaModelException {
        CompilationUnitResolver compilationUnitVisitor = new CompilationUnitResolver(CompilationUnitResolver.getNameEnvironment(javaProject), CompilationUnitResolver.getHandlingPolicy(), javaProject.getOptions(true), CompilationUnitResolver.getRequestor(), new DefaultProblemFactory());
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = javaProject.getOption("org.eclipse.jdt.core.encoding", true);
            CompilationUnitDeclaration compilationUnitDeclaration = unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(source, null, unitName, encoding), true, true, true);
            Object var7_8 = null;
            if (cleanUp && unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_9 = null;
                if (!cleanUp || unit == null) break block3;
                unit.cleanUp();
            }
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration resolve(ICompilationUnit unitElement, NodeSearcher nodeSearcher, boolean cleanUp, char[] source) throws JavaModelException {
        CompilationUnitDeclaration unit = null;
        try {
            char[] fileName = unitElement.getElementName().toCharArray();
            IJavaProject project = unitElement.getJavaProject();
            CompilationUnitResolver compilationUnitVisitor = new CompilationUnitResolver(CompilationUnitResolver.getNameEnvironment(unitElement), CompilationUnitResolver.getHandlingPolicy(), project.getOptions(true), CompilationUnitResolver.getRequestor(), new DefaultProblemFactory());
            String encoding = project.getOption("org.eclipse.jdt.core.encoding", true);
            IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(source, expectedPackageName, new String(fileName), encoding), nodeSearcher, true, true, true);
            Object var11_12 = null;
            if (cleanUp && unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block4: {
                Object var11_13 = null;
                if (!cleanUp || unit == null) break block4;
                unit.cleanUp();
            }
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration resolve(char[] source, char[][] packageName, String unitName, IJavaProject javaProject, boolean cleanUp) throws JavaModelException {
        CompilationUnitResolver compilationUnitVisitor = new CompilationUnitResolver(CompilationUnitResolver.getNameEnvironment(javaProject), CompilationUnitResolver.getHandlingPolicy(), javaProject.getOptions(true), CompilationUnitResolver.getRequestor(), new DefaultProblemFactory());
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = javaProject.getOption("org.eclipse.jdt.core.encoding", true);
            CompilationUnitDeclaration compilationUnitDeclaration = unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(source, packageName, unitName, encoding), true, true, true);
            Object var8_9 = null;
            if (cleanUp && unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_10 = null;
                if (!cleanUp || unit == null) break block3;
                unit.cleanUp();
            }
            throw throwable;
        }
    }

    public void removeUnresolvedBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            int i = 0;
            int max = types.length;
            while (i < max) {
                this.removeUnresolvedBindings(types[i]);
                ++i;
            }
        }
    }

    private void removeUnresolvedBindings(TypeDeclaration type) {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields;
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int i = 0;
            int max = memberTypes.length;
            while (i < max) {
                this.removeUnresolvedBindings(memberTypes[i]);
                ++i;
            }
        }
        if (type.binding != null && (type.binding.modifiers & 0x2000000) != 0) {
            type.binding = null;
        }
        if ((fields = type.fields) != null) {
            int i = 0;
            int max = fields.length;
            while (i < max) {
                if (fields[i].binding != null && (fields[i].binding.modifiers & 0x2000000) != 0) {
                    fields[i].binding = null;
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            int max = methods.length;
            while (i < max) {
                if (methods[i].binding != null && (methods[i].binding.modifiers & 0x2000000) != 0) {
                    methods[i].binding = null;
                }
                ++i;
            }
        }
    }

    public CompilationUnitDeclaration resolve(org.eclipse.jdt.internal.compiler.env.ICompilationUnit compilationUnit, NodeSearcher nodeSearcher, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        CompilationUnitDeclaration unit = null;
        try {
            this.parseThreshold = 0;
            this.beginToCompile(new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]{compilationUnit});
            unit = this.unitsToProcess[0];
            int searchPosition = nodeSearcher.position;
            if (searchPosition >= 0 && searchPosition <= compilationUnit.getContents().length) {
                unit.traverse((ASTVisitor)nodeSearcher, unit.scope);
                ASTNode node = nodeSearcher.found;
                if (node != null) {
                    TypeDeclaration enclosingTypeDeclaration = nodeSearcher.enclosingType;
                    if (node instanceof AbstractMethodDeclaration) {
                        ((AbstractMethodDeclaration)node).parseStatements(this.parser, unit);
                    } else if (enclosingTypeDeclaration != null) {
                        if (node instanceof Initializer) {
                            ((Initializer)node).parseStatements(this.parser, enclosingTypeDeclaration, unit);
                        } else if (node instanceof TypeDeclaration) {
                            ((TypeDeclaration)node).parseMethod(this.parser, unit);
                        }
                    }
                }
            }
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                if (unit.scope != null && verifyMethods) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
                if (analyzeCode) {
                    unit.analyseCode();
                }
                if (generateCode) {
                    unit.generateCode();
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return null;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }

    public CompilationUnitDeclaration resolve(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(null, sourceUnit, verifyMethods, analyzeCode, generateCode);
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        try {
            if (unit == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]{sourceUnit});
                unit = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(unit);
                this.lookupEnvironment.completeTypeBindings();
            }
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                if (unit.scope != null && verifyMethods) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
                if (analyzeCode) {
                    unit.analyseCode();
                }
                if (generateCode) {
                    unit.generateCode();
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }
}

