/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocArraySingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class JavadocParser {
    public static final char[] TAG_DEPRECATED = "deprecated".toCharArray();
    public static final char[] TAG_PARAM = "param".toCharArray();
    public static final char[] TAG_RETURN = "return".toCharArray();
    public static final char[] TAG_THROWS = "throws".toCharArray();
    public static final char[] TAG_EXCEPTION = "exception".toCharArray();
    public static final char[] TAG_SEE = "see".toCharArray();
    public static final int ORDERED_TAGS_NUMBER = 3;
    public static final int PARAM_TAG_EXPECTED_ORDER = 0;
    public static final int THROWS_TAG_EXPECTED_ORDER = 1;
    public static final int SEE_TAG_EXPECTED_ORDER = 2;
    public Javadoc javadoc;
    public boolean checkJavadoc = false;
    public Scanner scanner;
    private int currentTokenType = -1;
    private Parser sourceParser;
    private int index;
    private int tagSourceStart;
    private int tagSourceEnd;
    private int lineEnd;
    private char[] source;
    protected int identifierPtr;
    protected char[][] identifierStack;
    protected int identifierLengthPtr;
    protected int[] identifierLengthStack;
    protected long[] identifierPositionStack;
    protected static int AstStackIncrement = 10;
    protected int astPtr;
    protected ASTNode[] astStack;
    protected int astLengthPtr;
    protected int[] astLengthStack;

    JavadocParser(Parser sourceParser) {
        this.sourceParser = sourceParser;
        this.checkJavadoc = this.sourceParser.options.getSeverity(0x800000000L) != -1 || this.sourceParser.options.getSeverity(0x8000000000L) != -1;
        this.scanner = new Scanner(false, false, false, 0x2F0000L, null, null);
        this.identifierStack = new char[10][];
        this.identifierPositionStack = new long[10];
        this.identifierLengthStack = new int[20];
        this.astStack = new ASTNode[20];
        this.astLengthStack = new int[30];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDeprecation(int javadocStart, int javadocEnd) {
        boolean foundDeprecated = false;
        try {
            this.source = this.sourceParser.scanner.source;
            if (this.checkJavadoc) {
                this.javadoc = new Javadoc(javadocStart, javadocEnd);
                this.astLengthPtr = -1;
                this.astPtr = -1;
                this.currentTokenType = -1;
            } else {
                this.javadoc = this.sourceParser.options.getSeverity(0x10000000000L) != -1 ? new Javadoc(javadocStart, javadocEnd) : null;
            }
            int firstLineNumber = this.sourceParser.scanner.getLineNumber(javadocStart);
            int lastLineNumber = this.sourceParser.scanner.getLineNumber(javadocEnd);
            int line = firstLineNumber;
            block14: while (line <= lastLineNumber) {
                int lineStart;
                this.index = lineStart = line == firstLineNumber ? javadocStart + 3 : this.sourceParser.scanner.getLineStart(line);
                this.lineEnd = line == lastLineNumber ? javadocEnd - 2 : this.sourceParser.scanner.getLineEnd(line);
                block15: while (this.index < this.lineEnd) {
                    char nextCharacter = this.readChar();
                    switch (nextCharacter) {
                        case '@': {
                            if (!this.checkJavadoc) {
                                if (this.readChar() != 'd' || this.readChar() != 'e' || this.readChar() != 'p' || this.readChar() != 'r' || this.readChar() != 'e' || this.readChar() != 'c' || this.readChar() != 'a' || this.readChar() != 't' || this.readChar() != 'e' || this.readChar() != 'd' || !Character.isWhitespace(nextCharacter = this.readChar()) && nextCharacter != '*') break block15;
                                foundDeprecated = true;
                                break block14;
                            }
                            this.scanner.resetTo(this.index, this.lineEnd);
                            this.currentTokenType = -1;
                            try {
                                int tk = this.readTokenAndConsume();
                                this.tagSourceStart = this.scanner.getCurrentTokenStartPosition();
                                this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
                                switch (tk) {
                                    case 24: {
                                        char[] tag = this.scanner.getCurrentIdentifierSource();
                                        if (CharOperation.equals(tag, TAG_DEPRECATED)) {
                                            foundDeprecated = true;
                                            break;
                                        }
                                        if (CharOperation.equals(tag, TAG_PARAM)) {
                                            this.parseParam();
                                            break;
                                        }
                                        if (CharOperation.equals(tag, TAG_EXCEPTION)) {
                                            this.parseThrows();
                                            break;
                                        }
                                        if (!CharOperation.equals(tag, TAG_SEE)) break block15;
                                        this.parseSee();
                                        break;
                                    }
                                    case 84: {
                                        this.parseReturn();
                                        break;
                                    }
                                    case 97: {
                                        this.parseThrows();
                                        break;
                                    }
                                }
                            }
                            catch (InvalidInputException e) {
                                this.consumeToken();
                            }
                            break block15;
                        }
                        case '*': {
                            break;
                        }
                        default: {
                            if (!CharOperation.isWhitespace(nextCharacter)) break block15;
                        }
                    }
                }
                ++line;
            }
            Object var11_14 = null;
            if (this.checkJavadoc) {
                this.updateJavadoc();
            }
            this.source = null;
            return foundDeprecated;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (this.checkJavadoc) {
                this.updateJavadoc();
            }
            this.source = null;
            throw throwable;
        }
    }

    private void consumeToken() {
        this.currentTokenType = -1;
    }

    private int getEndPosition() {
        if (this.scanner.getCurrentTokenEndPosition() >= this.lineEnd) {
            return this.lineEnd - 1;
        }
        return this.scanner.getCurrentTokenEndPosition();
    }

    private Expression parseArguments(TypeReference receiver) throws InvalidInputException {
        int modulo = 0;
        int iToken = 0;
        char[] argName = null;
        int ptr = this.astPtr;
        int lptr = this.astLengthPtr;
        boolean isConstructor = true;
        if (receiver != null) {
            char[][] receiverTokens = receiver.getTypeName();
            char[] memberName = this.identifierStack[0];
            isConstructor = CharOperation.equals(memberName, receiverTokens[receiverTokens.length - 1]);
        }
        block2: while (this.index < this.scanner.eofPosition) {
            JavadocArgumentExpression expr;
            char[] name;
            boolean firstArg;
            TypeReference typeRef;
            try {
                typeRef = this.parseQualifiedName(false);
            }
            catch (InvalidInputException e) {
                break;
            }
            boolean bl = firstArg = modulo == 0;
            if (!firstArg ? iToken % modulo != 0 : iToken != 0) break;
            if (typeRef == null) {
                if (!firstArg || this.currentTokenType != 29) break;
                if (isConstructor) {
                    JavadocAllocationExpression expr2 = new JavadocAllocationExpression(this.identifierPositionStack[0]);
                    expr2.type = receiver;
                    return expr2;
                }
                JavadocMessageSend msg = new JavadocMessageSend(this.identifierStack[0], this.identifierPositionStack[0]);
                msg.receiver = receiver;
                return msg;
            }
            int argStart = typeRef.sourceStart;
            int argEnd = typeRef.sourceEnd;
            ++iToken;
            int dim = 0;
            if (this.readToken() == 7) {
                while (this.readToken() == 7) {
                    this.consumeToken();
                    if (this.readToken() != 73) break block2;
                    this.consumeToken();
                    ++dim;
                }
                long pos = (long)typeRef.sourceStart << 32 + typeRef.sourceEnd;
                if (typeRef instanceof JavadocSingleTypeReference) {
                    JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                    typeRef = new JavadocArraySingleTypeReference(singleRef.token, dim, pos);
                } else {
                    JavadocQualifiedTypeReference qualifRef = (JavadocQualifiedTypeReference)typeRef;
                    typeRef = new JavadocArrayQualifiedTypeReference(qualifRef, dim);
                }
            }
            if (this.readToken() == 24) {
                this.consumeToken();
                if (!firstArg ? iToken % modulo != 1 : iToken != 1) break;
                if (argName == null && !firstArg) break;
                argName = this.scanner.getCurrentIdentifierSource();
                argEnd = this.scanner.getCurrentTokenEndPosition();
                ++iToken;
            } else if (argName != null) break;
            if (firstArg) {
                modulo = iToken + 1;
            } else if (iToken % modulo != modulo - 1) break;
            int token = this.readToken();
            char[] cArray = name = argName == null ? new char[]{} : argName;
            if (token == 33) {
                expr = new JavadocArgumentExpression(name, argStart, argEnd, typeRef);
                this.pushOnAstStack(expr, firstArg);
                this.consumeToken();
                ++iToken;
                continue;
            }
            if (token != 29) break;
            expr = new JavadocArgumentExpression(name, argStart, argEnd, typeRef);
            this.pushOnAstStack(expr, firstArg);
            int size = this.astLengthStack[this.astLengthPtr--];
            JavadocArgumentExpression[] arguments = new JavadocArgumentExpression[size];
            int i = size - 1;
            while (i >= 0) {
                arguments[i] = (JavadocArgumentExpression)this.astStack[this.astPtr--];
                --i;
            }
            if (isConstructor) {
                JavadocAllocationExpression alloc = new JavadocAllocationExpression(this.identifierPositionStack[0]);
                alloc.arguments = arguments;
                alloc.type = receiver;
                return alloc;
            }
            JavadocMessageSend msg = new JavadocMessageSend(this.identifierStack[0], this.identifierPositionStack[0], arguments);
            msg.receiver = receiver;
            return msg;
        }
        this.consumeToken();
        if (iToken > 0) {
            this.astPtr = ptr;
            this.astLengthPtr = lptr;
        }
        throw new InvalidInputException();
    }

    private boolean parseHref() throws InvalidInputException {
        int start = this.scanner.getCurrentTokenStartPosition();
        if (this.readTokenAndConsume() == 24 && CharOperation.equals(this.scanner.getCurrentIdentifierSource(), new char[]{'a'}, false) && this.readTokenAndConsume() == 24) {
            try {
                if (CharOperation.equals(this.scanner.getCurrentIdentifierSource(), new char[]{'h', 'r', 'e', 'f'}, false) && this.readTokenAndConsume() == 100 && this.readTokenAndConsume() == 60 && this.readTokenAndConsume() == 16) {
                    while (this.readTokenAndConsume() != 17) {
                        if (this.scanner.currentPosition < this.lineEnd) continue;
                        this.sourceParser.problemReporter().javadocInvalidSeeUrlReference(start, this.lineEnd - 1);
                        return false;
                    }
                    if (this.readTokenAndConsume() == 6 && this.readTokenAndConsume() == 24 && CharOperation.equals(this.scanner.getCurrentIdentifierSource(), new char[]{'a'}, false) && this.readTokenAndConsume() == 16) {
                        return true;
                    }
                }
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        this.sourceParser.problemReporter().javadocInvalidSeeUrlReference(start, this.lineEnd - 1);
        return false;
    }

    private Expression parseMember(TypeReference receiver) throws InvalidInputException {
        this.identifierPtr = -1;
        this.identifierLengthPtr = -1;
        int start = this.scanner.getCurrentTokenStartPosition();
        TypeReference typeRef = receiver;
        if (typeRef == null) {
            char[] name = this.sourceParser.compilationUnit.compilationResult.compilationUnit.getMainTypeName();
            if (name == null) {
                throw new InvalidInputException();
            }
            typeRef = new JavadocSingleTypeReference(name, 0L, 0, 0);
        }
        if (this.readTokenAndConsume() == 24) {
            this.pushIdentifier(true);
            if (this.readTokenAndConsume() == 21) {
                start = this.scanner.getCurrentTokenStartPosition();
                try {
                    return this.parseArguments(typeRef);
                }
                catch (InvalidInputException e) {
                    int end = this.scanner.getCurrentTokenEndPosition() < this.lineEnd ? this.scanner.getCurrentTokenEndPosition() : this.scanner.getCurrentTokenStartPosition();
                    end = end < this.lineEnd ? end : this.lineEnd - 1;
                    this.sourceParser.problemReporter().javadocInvalidSeeReferenceArgs(start, end);
                    return null;
                }
            }
            JavadocFieldReference field = new JavadocFieldReference(this.identifierStack[0], this.identifierPositionStack[0]);
            field.receiver = typeRef;
            field.tagSourceStart = this.tagSourceStart;
            field.tagSourceEnd = this.tagSourceEnd;
            return field;
        }
        this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.getEndPosition());
        return null;
    }

    private void parseParam() {
        int start = this.tagSourceStart;
        int end = this.tagSourceEnd;
        try {
            int token = this.readTokenAndConsume();
            switch (token) {
                case 24: {
                    JavadocSingleNameReference argument = new JavadocSingleNameReference(this.scanner.getCurrentIdentifierSource(), this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    argument.tagSourceStart = this.tagSourceStart;
                    argument.tagSourceEnd = this.tagSourceEnd;
                    this.pushParamName(argument);
                    return;
                }
                case 75: {
                    break;
                }
                default: {
                    start = this.scanner.getCurrentTokenStartPosition();
                    end = this.scanner.getCurrentTokenEndPosition();
                    break;
                }
            }
        }
        catch (InvalidInputException e) {
            end = this.getEndPosition();
        }
        this.sourceParser.problemReporter().javadocMissingParamName(start, end);
        this.consumeToken();
    }

    private TypeReference parseQualifiedName(boolean reset) throws InvalidInputException {
        int size;
        if (reset) {
            this.identifierPtr = -1;
            this.identifierLengthPtr = -1;
        }
        int iToken = 0;
        block5: while (true) {
            int token = this.readToken();
            switch (token) {
                case 24: {
                    if (iToken % 2 > 0) break block5;
                    this.pushIdentifier(iToken == 0);
                    this.consumeToken();
                    break;
                }
                case 1: {
                    if (iToken % 2 == 0) {
                        throw new InvalidInputException();
                    }
                    this.consumeToken();
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    if (iToken > 0) {
                        throw new InvalidInputException();
                    }
                    this.pushIdentifier(true);
                    this.consumeToken();
                    break block5;
                }
                default: {
                    if (iToken == 0) {
                        return null;
                    }
                    if (iToken % 2 != 0) break block5;
                    throw new InvalidInputException();
                }
            }
            ++iToken;
        }
        TypeReference typeRef = null;
        if ((size = this.identifierLengthStack[this.identifierLengthPtr--]) == 1) {
            typeRef = new JavadocSingleTypeReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr], this.tagSourceStart, this.tagSourceEnd);
        } else if (size > 1) {
            char[][] tokens = new char[size][];
            System.arraycopy(this.identifierStack, this.identifierPtr - size + 1, tokens, 0, size);
            long[] positions = new long[size];
            System.arraycopy(this.identifierPositionStack, this.identifierPtr - size + 1, positions, 0, size);
            typeRef = new JavadocQualifiedTypeReference(tokens, positions, this.tagSourceStart, this.tagSourceEnd);
        }
        this.identifierPtr -= size;
        return typeRef;
    }

    private Expression parseReference() throws InvalidInputException {
        TypeReference typeRef = null;
        Expression reference = null;
        block12: while (this.index < this.scanner.eofPosition) {
            int token = this.readToken();
            switch (token) {
                case 60: {
                    int start = this.scanner.getCurrentTokenStartPosition();
                    if (typeRef == null) {
                        this.consumeToken();
                        try {
                            if (this.readToken() == 75) {
                                return null;
                            }
                        }
                        catch (InvalidInputException invalidInputException) {
                            // empty catch block
                        }
                    }
                    this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.lineEnd - 1);
                    return null;
                }
                case 17: {
                    this.consumeToken();
                    int start = this.scanner.getCurrentTokenStartPosition();
                    if (this.parseHref()) {
                        if (typeRef == null) {
                            this.consumeToken();
                            try {
                                if (this.readToken() == 75) {
                                    return null;
                                }
                            }
                            catch (InvalidInputException invalidInputException) {
                                // empty catch block
                            }
                        }
                        this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.lineEnd - 1);
                    }
                    return null;
                }
                case 112: {
                    this.consumeToken();
                    if (this.scanner.currentCharacter != '#' || (reference = this.parseMember(typeRef)) != null) break block12;
                    return null;
                }
                case 24: {
                    if (typeRef != null) break block12;
                    typeRef = this.parseQualifiedName(true);
                    break;
                }
                default: {
                    break block12;
                }
            }
        }
        if (reference == null) {
            reference = typeRef;
        }
        if (reference == null) {
            this.sourceParser.problemReporter().javadocMissingSeeReference(this.tagSourceStart, this.tagSourceEnd);
            return null;
        }
        int start = this.scanner.getCurrentTokenStartPosition();
        try {
            int token = this.readTokenAndConsume();
            if (token != 21) {
                return reference;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.lineEnd - 1);
        return null;
    }

    private void parseReturn() {
        if (this.javadoc.returnStatement == null) {
            this.javadoc.returnStatement = new JavadocReturnStatement(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), this.scanner.getRawTokenSourceEnd());
        } else {
            this.sourceParser.problemReporter().javadocDuplicatedReturnTag(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSee() {
        int start = this.scanner.currentPosition;
        try {
            try {
                Expression msgRef = this.parseReference();
                if (msgRef != null) {
                    this.pushSeeRef(msgRef);
                }
            }
            catch (InvalidInputException ex) {
                this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.getEndPosition());
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.consumeToken();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.consumeToken();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseThrows() {
        int start = this.scanner.currentPosition;
        try {
            block6: {
                try {
                    TypeReference typeRef = this.parseQualifiedName(true);
                    if (typeRef == null) {
                        this.sourceParser.problemReporter().javadocMissingThrowsClassName(this.tagSourceStart, this.tagSourceEnd);
                        break block6;
                    }
                    this.pushThrowName(typeRef);
                }
                catch (InvalidInputException ex) {
                    this.sourceParser.problemReporter().javadocInvalidThrowsClass(start, this.getEndPosition());
                }
            }
            Object var3_6 = null;
            this.consumeToken();
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.consumeToken();
            throw throwable;
        }
    }

    private void pushIdentifier(boolean newLength) {
        Object oldStack;
        int oldStackLength;
        try {
            this.identifierStack[++this.identifierPtr] = this.scanner.getCurrentIdentifierSource();
            this.identifierPositionStack[this.identifierPtr] = ((long)this.scanner.startPosition << 32) + (long)(this.scanner.currentPosition - 1);
        }
        catch (IndexOutOfBoundsException e) {
            oldStackLength = this.identifierStack.length;
            oldStack = this.identifierStack;
            this.identifierStack = new char[oldStackLength + 10][];
            System.arraycopy(oldStack, 0, this.identifierStack, 0, oldStackLength);
            this.identifierStack[this.identifierPtr] = this.scanner.getCurrentTokenSource();
            long[] oldPos = this.identifierPositionStack;
            this.identifierPositionStack = new long[oldStackLength + 10];
            System.arraycopy(oldPos, 0, this.identifierPositionStack, 0, oldStackLength);
            this.identifierPositionStack[this.identifierPtr] = ((long)this.scanner.startPosition << 32) + (long)(this.scanner.currentPosition - 1);
        }
        if (newLength) {
            try {
                this.identifierLengthStack[++this.identifierLengthPtr] = 1;
            }
            catch (IndexOutOfBoundsException e) {
                oldStackLength = this.identifierLengthStack.length;
                oldStack = this.identifierLengthStack;
                this.identifierLengthStack = new int[oldStackLength + 10];
                System.arraycopy(oldStack, 0, this.identifierLengthStack, 0, oldStackLength);
                this.identifierLengthStack[this.identifierLengthPtr] = 1;
            }
        } else {
            int n = this.identifierLengthPtr;
            this.identifierLengthStack[n] = this.identifierLengthStack[n] + 1;
        }
    }

    private void pushOnAstStack(ASTNode node, boolean newLength) {
        int oldStackLength;
        if (node == null) {
            this.astLengthStack[++this.astLengthPtr] = 0;
            return;
        }
        try {
            this.astStack[++this.astPtr] = node;
        }
        catch (IndexOutOfBoundsException e) {
            oldStackLength = this.astStack.length;
            ASTNode[] oldStack = this.astStack;
            this.astStack = new ASTNode[oldStackLength + AstStackIncrement];
            System.arraycopy(oldStack, 0, this.astStack, 0, oldStackLength);
            this.astPtr = oldStackLength;
            this.astStack[this.astPtr] = node;
        }
        if (newLength) {
            try {
                this.astLengthStack[++this.astLengthPtr] = 1;
            }
            catch (IndexOutOfBoundsException e) {
                oldStackLength = this.astLengthStack.length;
                int[] oldPos = this.astLengthStack;
                this.astLengthStack = new int[oldStackLength + AstStackIncrement];
                System.arraycopy(oldPos, 0, this.astLengthStack, 0, oldStackLength);
                this.astLengthStack[this.astLengthPtr] = 1;
            }
        } else {
            int n = this.astLengthPtr;
            this.astLengthStack[n] = this.astLengthStack[n] + 1;
        }
    }

    private void pushParamName(JavadocSingleNameReference arg) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(arg, true);
        } else {
            int i = 1;
            while (i <= this.astLengthPtr) {
                if (this.astLengthStack[i] != 0) {
                    this.sourceParser.problemReporter().javadocUnexpectedTag(arg.tagSourceStart, arg.tagSourceEnd);
                    return;
                }
                i += 3;
            }
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(arg, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(arg, true);
                }
            }
        }
    }

    private void pushSeeRef(Statement statement) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(statement, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(statement, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(statement, true);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(statement, false);
                }
            }
        }
    }

    private void pushThrowName(TypeReference typeRef) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(typeRef, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(typeRef, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(typeRef, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(typeRef, true);
                }
            }
        }
    }

    private char readChar() {
        char c;
        if ((c = this.source[this.index++]) == '\\') {
            int c4;
            int c3;
            int c2;
            int c1;
            ++this.index;
            while (this.source[this.index] == 'u') {
                ++this.index;
            }
            if ((c1 = Character.getNumericValue(this.source[this.index++])) <= 15 && c1 >= 0 && (c2 = Character.getNumericValue(this.source[this.index++])) <= 15 && c2 >= 0 && (c3 = Character.getNumericValue(this.source[this.index++])) <= 15 && c3 >= 0 && (c4 = Character.getNumericValue(this.source[this.index++])) <= 15 && c4 >= 0) {
                c = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
            }
        }
        return c;
    }

    private int readToken() throws InvalidInputException {
        if (this.currentTokenType < 0) {
            this.currentTokenType = this.scanner.getNextToken();
            this.index = this.scanner.currentPosition;
        }
        return this.currentTokenType;
    }

    private int readTokenAndConsume() throws InvalidInputException {
        int token = this.readToken();
        this.consumeToken();
        return token;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("check javadoc: ").append(this.checkJavadoc).append("\n");
        buffer.append("javadoc: ").append(this.javadoc).append("\n");
        return buffer.toString();
    }

    private void updateJavadoc() {
        if (this.astLengthPtr == -1) {
            return;
        }
        int[] sizes = new int[3];
        int i = 0;
        while (i <= this.astLengthPtr) {
            int n = i % 3;
            sizes[n] = sizes[n] + this.astLengthStack[i];
            ++i;
        }
        this.javadoc.references = new Expression[sizes[2]];
        this.javadoc.thrownExceptions = new TypeReference[sizes[1]];
        this.javadoc.parameters = new JavadocSingleNameReference[sizes[0]];
        while (this.astLengthPtr >= 0) {
            int i2;
            int size;
            int ptr = this.astLengthPtr % 3;
            if (ptr == 2) {
                size = this.astLengthStack[this.astLengthPtr--];
                i2 = 0;
                while (i2 < size) {
                    int n = ptr;
                    int n2 = sizes[n] - 1;
                    sizes[n] = n2;
                    this.javadoc.references[n2] = (Expression)this.astStack[this.astPtr--];
                    ++i2;
                }
                continue;
            }
            if (ptr == 1) {
                size = this.astLengthStack[this.astLengthPtr--];
                i2 = 0;
                while (i2 < size) {
                    int n = ptr;
                    int n3 = sizes[n] - 1;
                    sizes[n] = n3;
                    this.javadoc.thrownExceptions[n3] = (TypeReference)this.astStack[this.astPtr--];
                    ++i2;
                }
                continue;
            }
            if (ptr != 0) continue;
            size = this.astLengthStack[this.astLengthPtr--];
            i2 = 0;
            while (i2 < size) {
                int n = ptr;
                int n4 = sizes[n] - 1;
                sizes[n] = n4;
                this.javadoc.parameters[n4] = (JavadocSingleNameReference)this.astStack[this.astPtr--];
                ++i2;
            }
        }
    }
}

