/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.VariableLocator;
import org.eclipse.jdt.internal.core.util.SimpleSet;

public class FieldLocator
extends VariableLocator {
    protected boolean isDeclarationOfAccessedFieldsPattern;

    public FieldLocator(FieldPattern pattern) {
        super(pattern);
        this.isDeclarationOfAccessedFieldsPattern = this.pattern instanceof DeclarationOfAccessedFieldsPattern;
    }

    public int match(FieldDeclaration node, MatchingNodeSet nodeSet) {
        int referencesLevel = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && node.initialization != null && this.matchesName(this.pattern.name, node.name)) {
            referencesLevel = this.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.pattern.findDeclarations && node.isField() && this.matchesName(this.pattern.name, node.name) && this.matchesTypeReference(((FieldPattern)this.pattern).typeSimpleName, node.type)) {
            declarationsLevel = this.pattern.mustResolve ? 2 : 3;
        }
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 14;
        }
        return 2;
    }

    protected int matchField(FieldBinding field, boolean matchName) {
        if (field == null) {
            return 1;
        }
        if (matchName && !this.matchesName(this.pattern.name, field.readableName())) {
            return 0;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        ReferenceBinding receiverBinding = field.declaringClass;
        if (receiverBinding == null) {
            if (field == ArrayBinding.ArrayLength) {
                return fieldPattern.declaringQualification == null && fieldPattern.declaringSimpleName == null ? 3 : 0;
            }
            return 1;
        }
        int declaringLevel = this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, receiverBinding);
        if (declaringLevel == 0) {
            return 0;
        }
        if (fieldPattern.declaringSimpleName == null) {
            return declaringLevel;
        }
        int typeLevel = this.resolveLevelForType(fieldPattern.typeSimpleName, fieldPattern.typeQualification, field.type);
        return declaringLevel > typeLevel ? typeLevel : declaringLevel;
    }

    protected int matchReference(Reference node, MatchingNodeSet nodeSet, boolean writeOnlyAccess) {
        if (node instanceof FieldReference) {
            if (this.matchesName(this.pattern.name, ((FieldReference)node).token)) {
                return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
            }
            return 0;
        }
        return super.matchReference(node, nodeSet, writeOnlyAccess);
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (this.isDeclarationOfAccessedFieldsPattern) {
            if (accuracy != 0) {
                return;
            }
            DeclarationOfAccessedFieldsPattern declPattern = (DeclarationOfAccessedFieldsPattern)this.pattern;
            while (element != null && !declPattern.enclosingElement.equals(element)) {
                element = element.getParent();
            }
            if (element != null) {
                if (reference instanceof FieldReference) {
                    this.reportDeclaration(((FieldReference)reference).binding, locator, declPattern.knownFields);
                } else if (reference instanceof QualifiedNameReference) {
                    QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
                    Binding binding = qNameRef.binding;
                    if (binding instanceof FieldBinding) {
                        this.reportDeclaration((FieldBinding)binding, locator, declPattern.knownFields);
                    }
                    int otherMax = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
                    int i = 0;
                    while (i < otherMax) {
                        this.reportDeclaration(qNameRef.otherBindings[i], locator, declPattern.knownFields);
                        ++i;
                    }
                } else if (reference instanceof SingleNameReference) {
                    this.reportDeclaration((FieldBinding)((SingleNameReference)reference).binding, locator, declPattern.knownFields);
                }
            }
        } else if (reference instanceof FieldReference) {
            long position = ((FieldReference)reference).nameSourcePosition;
            locator.report(position, position, element, accuracy);
        } else if (reference instanceof SingleNameReference) {
            locator.report(reference.sourceStart, reference.sourceEnd, element, accuracy);
        } else if (reference instanceof QualifiedNameReference) {
            QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
            int length = qNameRef.tokens.length;
            int[] accuracies = new int[length];
            Binding binding = qNameRef.binding;
            int indexOfFirstFieldBinding = qNameRef.indexOfFirstFieldBinding > 0 ? qNameRef.indexOfFirstFieldBinding - 1 : 0;
            int i = 0;
            while (i < indexOfFirstFieldBinding) {
                accuracies[i] = -1;
                ++i;
            }
            if (this.matchesName(this.pattern.name, qNameRef.tokens[indexOfFirstFieldBinding]) && !(binding instanceof LocalVariableBinding)) {
                FieldBinding fieldBinding;
                FieldBinding fieldBinding2 = fieldBinding = binding instanceof FieldBinding ? (FieldBinding)binding : null;
                if (fieldBinding == null) {
                    accuracies[indexOfFirstFieldBinding] = accuracy;
                } else {
                    switch (this.matchField(fieldBinding, false)) {
                        case 3: {
                            accuracies[indexOfFirstFieldBinding] = 0;
                            break;
                        }
                        case 1: {
                            accuracies[indexOfFirstFieldBinding] = 1;
                            break;
                        }
                        default: {
                            accuracies[indexOfFirstFieldBinding] = -1;
                            break;
                        }
                    }
                }
            } else {
                accuracies[indexOfFirstFieldBinding] = -1;
            }
            i = indexOfFirstFieldBinding + 1;
            while (i < length) {
                char[] token = qNameRef.tokens[i];
                if (this.matchesName(this.pattern.name, token)) {
                    FieldBinding otherBinding;
                    FieldBinding fieldBinding = otherBinding = qNameRef.otherBindings == null ? null : qNameRef.otherBindings[i - (indexOfFirstFieldBinding + 1)];
                    if (otherBinding == null) {
                        accuracies[i] = accuracy;
                    } else {
                        switch (this.matchField(otherBinding, false)) {
                            case 3: {
                                accuracies[i] = 0;
                                break;
                            }
                            case 1: {
                                accuracies[i] = 1;
                                break;
                            }
                            default: {
                                accuracies[i] = -1;
                                break;
                            }
                        }
                    }
                } else {
                    accuracies[i] = -1;
                }
                ++i;
            }
            locator.reportAccurateReference(reference.sourceStart, reference.sourceEnd, qNameRef.tokens, element, accuracies);
        }
    }

    protected void reportDeclaration(FieldBinding fieldBinding, MatchLocator locator, SimpleSet knownFields) throws CoreException {
        if (fieldBinding == ArrayBinding.ArrayLength) {
            return;
        }
        ReferenceBinding declaringClass = fieldBinding.declaringClass;
        IType type = locator.lookupType(declaringClass);
        if (type == null) {
            return;
        }
        char[] bindingName = fieldBinding.name;
        IField field = type.getField(new String(bindingName));
        if (knownFields.includes(field)) {
            return;
        }
        knownFields.add(field);
        IResource resource = type.getResource();
        boolean isBinary = type.isBinary();
        IBinaryType info = null;
        if (isBinary) {
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
            locator.reportBinaryMatch(resource, field, info, 0);
        } else {
            ClassScope scope = ((SourceTypeBinding)declaringClass).scope;
            if (scope != null) {
                TypeDeclaration typeDecl = scope.referenceContext;
                FieldDeclaration fieldDecl = null;
                FieldDeclaration[] fieldDecls = typeDecl.fields;
                int i = 0;
                int length = fieldDecls.length;
                while (i < length) {
                    if (CharOperation.equals(bindingName, fieldDecls[i].name)) {
                        fieldDecl = fieldDecls[i];
                        break;
                    }
                    ++i;
                }
                if (fieldDecl != null) {
                    locator.report(resource, fieldDecl.sourceStart, fieldDecl.sourceEnd, field, 0, locator.getParticipant());
                }
            }
        }
    }

    public int resolveLevel(ASTNode possiblelMatchingNode) {
        if (this.pattern.findReferences) {
            if (possiblelMatchingNode instanceof FieldReference) {
                return this.matchField(((FieldReference)possiblelMatchingNode).binding, true);
            }
            if (possiblelMatchingNode instanceof NameReference) {
                return this.resolveLevel((NameReference)possiblelMatchingNode);
            }
        }
        if (possiblelMatchingNode instanceof FieldDeclaration) {
            return this.matchField(((FieldDeclaration)possiblelMatchingNode).binding, true);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof FieldBinding)) {
            return 0;
        }
        return this.matchField((FieldBinding)binding, true);
    }

    protected int resolveLevel(NameReference nameRef) {
        if (nameRef instanceof SingleNameReference) {
            return this.resolveLevel(nameRef.binding);
        }
        Binding binding = nameRef.binding;
        QualifiedNameReference qNameRef = (QualifiedNameReference)nameRef;
        FieldBinding fieldBinding = null;
        if (binding instanceof FieldBinding) {
            fieldBinding = (FieldBinding)binding;
            char[] bindingName = fieldBinding.name;
            int lastDot = CharOperation.lastIndexOf('.', bindingName);
            if (lastDot > -1) {
                bindingName = CharOperation.subarray(bindingName, lastDot + 1, bindingName.length);
            }
            if (this.matchesName(this.pattern.name, bindingName)) {
                return this.matchField(fieldBinding, false);
            }
        }
        int otherMax = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
        int i = 0;
        while (i < otherMax) {
            FieldBinding otherBinding;
            int level;
            char[] token = qNameRef.tokens[i + qNameRef.indexOfFirstFieldBinding];
            if (this.matchesName(this.pattern.name, token) && (level = this.matchField(otherBinding = qNameRef.otherBindings[i], false)) != 0) {
                return level;
            }
            ++i;
        }
        return 0;
    }
}

